<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class DrishtiCompressedFeature extends \Google\Model
{
  /**
   * @var string
   */
  public $featureName;
  /**
   * @var string
   */
  public $inRangeBitstream;
  /**
   * @var string
   */
  public $outOfRangeBitstream;

  /**
   * @param string
   */
  public function setFeatureName($featureName)
  {
    $this->featureName = $featureName;
  }
  /**
   * @return string
   */
  public function getFeatureName()
  {
    return $this->featureName;
  }
  /**
   * @param string
   */
  public function setInRangeBitstream($inRangeBitstream)
  {
    $this->inRangeBitstream = $inRangeBitstream;
  }
  /**
   * @return string
   */
  public function getInRangeBitstream()
  {
    return $this->inRangeBitstream;
  }
  /**
   * @param string
   */
  public function setOutOfRangeBitstream($outOfRangeBitstream)
  {
    $this->outOfRangeBitstream = $outOfRangeBitstream;
  }
  /**
   * @return string
   */
  public function getOutOfRangeBitstream()
  {
    return $this->outOfRangeBitstream;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DrishtiCompressedFeature::class, 'Google_Service_Contentwarehouse_DrishtiCompressedFeature');
