
 <!--section start --> 
<?php $__env->startSection('title',__('Homework - Admin')); ?>
<?php $__env->startSection('maincontent'); ?>
<?php
$data['heading'] = 'Homework';
$data['title'] = 'Homework';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <!--back and add homework button start--> 
 <!--contentbar start--> 
<div class="contentbar">
     <!--row start--> 
    <div class="row">
        <div class="col-lg-12">
              <!--card start--> 
            <div class="card dashboard-card m-b-30">
                  <!--card header start--> 
                <div class="card-header">
                    <h5 class="card-box"><?php echo e(__('Homework')); ?> <span class="text-muted">(<?php echo e(filter_var($course->title)); ?>)</span></h5>
                    <div>
                        <a href="<?php echo e(url('homework_create/'.$course->id)); ?>" class="float-right btn btn-primary-rgba "><i
                           class="feather icon-plus mr-2"></i><?php echo e(__("Add Homework")); ?></a>
                         <a href="<?php echo e(url('course')); ?>" class="btn btn-primary-rgba mr-2"><i class="feather icon-arrow-left mr-2"></i><?php echo e(__("Back")); ?></a>
                                    
                     </div>
                </div> 
               <!--card header end--> 
            
                 <!--card body start--> 
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable-buttons" class="table table-striped table-bordered">
                            <thead>
                                <th><?php echo e(__('Id')); ?></th>
                                <th><?php echo e(__('Title')); ?></th>
                                <th><?php echo e(__('Description')); ?></th>
                                <th><?php echo e(__('Submitted homwork')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Compulsory')); ?></th>
                                <th><?php echo e(__('Out of marks')); ?></th>
                                <th><?php echo e(__('Submission Date')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </thead>
                            <?php if(Auth::User()->role == "admin"): ?>
                            <tbody>
                                <?php $__currentLoopData = $homework; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $homework): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(filter_var($key+1)); ?></td>
                                    <td><?php echo e(filter_var($homework->title)); ?></td>
                                    <td><?php echo e(filter_var($homework->description)); ?></td>
                                    <td><a title="submitted homework" href="<?php echo e(route('homework.view',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-check-circle mr-2"></i></a></td>
                                    <td>
                                        <label class="switch">
                                            <input class="status" type="checkbox" data-id="<?php echo e(filter_var($homework->id)); ?>" name="status" <?php echo e(filter_var($homework->status) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="switch">
                                            <input class="compulsory" type="checkbox" data-id="<?php echo e(filter_var($homework->id)); ?>" name="compulsory" <?php echo e(filter_var($homework->compulsory) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>
                                    <td><?php echo e(filter_var($homework->marks)); ?></td>
                                    <td><?php echo e(filter_var($homework->endtime)); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-round btn-outline-primary" type="button" id="CustomdropdownMenuButton1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="feather icon-more-vertical-"></i></button>
                                            <div class="dropdown-menu" aria-labelledby="CustomdropdownMenuButton1">
                                                <a class="dropdown-item" href="<?php echo e(route('homework.download',["id" =>$homework->id])); ?>"><i class="feather icon-eye mr-2"></i><?php echo e(__("View Homework")); ?></a>
                                                <a class="dropdown-item" href="<?php echo e(route('homework.edit',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-edit mr-2"></i><?php echo e(__("Edit")); ?></a>
                                                <a class="dropdown-item" href="<?php echo e(route('homework.view',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-check-circle  mr-2"></i><?php echo e(__("Submitted Homework")); ?></a>
                                                <a class="dropdown-item btn btn-link" data-toggle="modal" data-target="#delete<?php echo e(filter_var($homework->id)); ?>" >
                                                    <i class="feather icon-delete mr-2"></i><?php echo e(__("Delete")); ?></a>
                                                </a>
                                            </div>
                                        </div>
    
                                        <!-- delete Modal start -->
                                        <div class="modal fade bd-example-modal-sm" id="delete<?php echo e(filter_var($homework->id)); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-sm">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleSmallModalLabel"><?php echo e(__("Delete")); ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                            <h4><?php echo e(__('Are You Sure ?')); ?></h4>
                                                            <p><?php echo e(__('Do you really want to delete')); ?> <b><?php echo e(filter_var($homework->title)); ?></b>  <?php echo e(__(' ? This process cannot be undone.')); ?></p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form method="post" action="<?php echo e(route('homework.delete',['id' => $homework->id])); ?>" >
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo e(method_field("DELETE")); ?>

                                                            <button type="reset" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("No")); ?></button>
                                                            <button type="submit" class="btn btn-danger"><?php echo e(__("Yes")); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- delete Model end -->
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php endif; ?>

                            <?php
                            $homework = Modules\Homework\Models\Homework::where('course_id',$course->id)
                                                                        ->where('user_id',Auth::User()->id)
                                                                        ->get();
                                                          
                            ?>
                            <?php if(Auth::User()->role == "instructor"): ?>
                            <tbody>
                                <?php $__currentLoopData = $homework; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $homework): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    
                                    <td><?php echo e(filter_var($key+1)); ?></td>
                                    <td><a href="<?php echo e(route('homework.download',["id" =>$homework->id])); ?>"> <i class="fa fa-download"></i></a></td>
                                    <td><?php echo e(filter_var($homework->title)); ?></td>
                                    <td><?php echo e(filter_var($homework->description)); ?></td>
                                    <td><a href="<?php echo e(route('homework.view',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-check-circle mr-2"></i></a></td>
                                    <td>
                                        <label class="switch">
                                            <input class="status" type="checkbox" data-id="<?php echo e($homework->id); ?>" name="status" <?php echo e(filter_var($homework->status) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>
                                    <td>
                                        <label class="switch">
                                            <input class="compulsory" type="checkbox" data-id="<?php echo e($homework->id); ?>" name="compulsory" <?php echo e(filter_var($homework->compulsory) == '1' ? 'checked' : ''); ?>>
                                            <span class="knob"></span>
                                        </label>
                                    </td>
                                    <td><?php echo e(filter_var($homework->endtime)); ?></td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-round btn-outline-primary" type="button" id="CustomdropdownMenuButton1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="feather icon-more-vertical-"></i></button>
                                            <div class="dropdown-menu" aria-labelledby="CustomdropdownMenuButton1">
                                                <a class="dropdown-item" href="<?php echo e(route('homework.edit',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-edit mr-2"></i><?php echo e(__("Edit")); ?></a>
                                                <a class="dropdown-item" href="<?php echo e(route('homework.view',["id" =>$homework->id,"cat" => $course->id])); ?>"><i class="feather icon-check-circle mr-2"></i><?php echo e(__("Submit Homework")); ?></a>
                                                <a class="dropdown-item btn btn-link" data-toggle="modal" data-target="#delete<?php echo e($homework->id); ?>" >
                                                    <i class="feather icon-delete mr-2"></i><?php echo e(__("Delete")); ?></a>
                                                </a>
                                            </div>
                                        </div>
    
                                        <!-- delete Modal start -->
                                        <div class="modal fade bd-example-modal-sm" id="delete<?php echo e($homework->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-sm">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleSmallModalLabel"><?php echo e(__("Delete")); ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                            <h4><?php echo e(__('Are You Sure ?')); ?></h4>
                                                            <p><?php echo e(__('Do you really want to delete')); ?> <b><?php echo e(filter_var($homework->title)); ?></b>  <?php echo e(__(' ? This process cannot be undone.')); ?></p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form method="post" action="<?php echo e(route('homework.delete',['id' => $homework->id])); ?>" >
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo e(method_field("DELETE")); ?>

                                                            <button type="reset" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__("M0")); ?></button>
                                                            <button type="submit" class="btn btn-danger"><?php echo e(__("Yes")); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- delete Model end -->
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php endif; ?>
                            
                        </table>                  
                    </div>
                   
                </div>
                <!--card body end--> 
            </div>
              <!--card end--> 
        </div>
    </div>
     <!--row end--> 
</div>
 <!--contentbar end --> 
 
<?php $__env->stopSection(); ?>
<!--section end --> 
<!-- This section will contain javacsript start -->
<?php $__env->startSection('script'); ?>
    <script>var url = <?php echo json_encode(url('/'), 15, 512) ?>;</script>
    <script src="<?php echo e(Module::asset('homework:js/status.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<!-- This section will contain javacsript end -->

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elimun/public_html/Modules/Homework/Resources/views/admin/homework/index.blade.php ENDPATH**/ ?>